//
//  Command.h
//  GSDK
//
//  Created by smarnet on 2019/2/26.
//  Copyright © 2019 Smarnet. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

/**
 *  @enum TextAngle
 *
 *  @discussion 文本旋转角度(Text rotation Angle)
 */
typedef NS_ENUM (NSUInteger,PrinterMode) {
    TSC_COMMAND, ///<TSC 指令类型  (TSC Command Type)
    ESC_COMMAND, ///<ESC 指令类型  (ESC Command Type)
    CPCL_COMMAND,///<CPCL 指令类型 (CPCL Command Type)
};

@interface Command : NSObject

@property(nonatomic, strong) NSMutableData *mCommandData;

/// 获得打印命令
/// @return 指令集
- (NSData *)getCommand;

/// 将字符串转成十六进制码
/// @param str 命令字符串
- (void)addStrToCommand:(NSString *)str;

/// 将字符串转成十六进制码
/// @param str 命令字符串
/// @param encoding 字符所用编码
- (void)addStrToCommand:(NSString *)str encoding:(NSStringEncoding)encoding;

/// 图片处理。使用该方法处理需打印图片，图片将进行灰度化及抖动处理，保留图片信息较全
/// @param image 需打印的图像
/// @return 返回处理后的图片
- (UIImage *)convertGreyImgByFloyd:(UIImage *)image;

/// 添加data到command
/// @param data 数据
- (void)addNSDataToCommand:(NSData*) data;

/// 切换打印机模式。该指令需单独发送给打印机，不能在getCommand函数中读取到该指令
/// @param mode 需要切换的模式
/// @return 切换打印机模式指令
- (NSData *)swithPrinterMode:(PrinterMode)mode;

/// 修改蓝牙前缀。该指令需单独发送给打印机，不能在getCommand函数中读取到该指令
/// @param name 蓝牙前缀
/// @return 修改蓝牙前缀指令
- (NSData *)addChangeBluetoothName:(NSString *)name;

/// 修改蓝牙PIN码（配对码）。该指令需单独发送给打印机，不能在getCommand函数中读取到该指令
/// @param code 蓝牙配对码。code.length=4。蓝牙配对码必须为0-9之间的数字
/// @return 修改蓝牙PIN码指令
- (NSData *)addChangeBluetoothPinCode:(NSString *)code;

@end

NS_ASSUME_NONNULL_END
